// Perception.cpp: implementation of the CPerception class, CPerceptionSeq.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Player.h"
#include "Perception.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


//////////////////////////////////////////////////////////////////////
// implementation of the CPerception class.
//////////////////////////////////////////////////////////////////////

// Construction/Destruction

CPerception::CPerception() {
	m_tType = MT_NoMsg;
	m_nPlayTime = -1;
	m_nSeenPlayersCount = 0;
	m_nSeenPlaymatesCount = 0;
	m_nSeenFlagsCount = 0;
	m_nSeenLinesCount = 0;
	m_bSeeLeftGoal = false;
	m_bSeeRightGoal = false;
	m_bSeeBall = false;
}

CPerception::CPerception(int playTime, CGameTime gameTime, EMsgType msgType) {
	m_tType = msgType;
	m_nPlayTime = playTime;
	m_nReceiveSystemTime = -1;
	m_nSeenPlayersCount = 0;
	m_nSeenPlaymatesCount = 0;
	m_nSeenFlagsCount = 0;
	m_nSeenLinesCount = 0;
	m_bSeeLeftGoal = false;
	m_bSeeRightGoal = false;
	m_bSeeBall = false;
}

CPerception::~CPerception() {
	m_tType = MT_NoMsg;
	m_nPlayTime = -1;
	m_nReceiveSystemTime = -1;
	m_nSeenPlayersCount = 0;
	m_nSeenPlaymatesCount = 0;
	m_nSeenFlagsCount = 0;
	m_nSeenLinesCount = 0;
	m_bSeeLeftGoal = false;
	m_bSeeRightGoal = false;
	m_bSeeBall = false;
}

void CPerception::ClearAll()
{
	m_tType = MT_NoMsg;
	m_nPlayTime = -1;
	m_nReceiveSystemTime = -1;
	m_nSeenPlayersCount = 0;
	m_nSeenPlaymatesCount = 0;
	m_nSeenFlagsCount = 0;
	m_nSeenLinesCount = 0;
	m_bSeeLeftGoal = false;
	m_bSeeRightGoal = false;
	m_bSeeBall = false;
	m_cSeenPlayers.clear();	
	m_cSeenFlags.clear();
	m_cSeenGoals.clear();
	m_cSeenLines.clear();
	m_cBall.Invalidate();
	m_cHeardMsg.Invalidate();
	m_cSenseBody.Invalidate();
	m_cInitMsg.Invalidate();
}

void CPerception::AddSeenPlayer(int uNum, char* teamName, double dist, double dir, double distChng, double dirChng, int setValues, double bodyDir, double headDir)
{
	CSeenPlayer player(uNum, teamName, bodyDir, headDir);
	player.SetDistance(dist);
	player.SetDirection(dir);
	player.SetDistanceChng(distChng);
	player.SetDirectionChng(dirChng);
	player.SetValuesVar(setValues);
	m_cSeenPlayers.push_back(player);
	
	m_nSeenPlayersCount++;	
}

void CPerception::AddSeenFlag(EFlagType flagID, double dist, double dir, double distChng, double dirChng, int setValues)
{
	CSeenFlag flag(flagID);
	flag.SetDistance(dist);
	flag.SetDirection(dir);
	flag.SetDistanceChng(distChng);
	flag.SetDirectionChng(dirChng);
	flag.SetValuesVar(setValues);
	m_cSeenFlags.push_back(flag);
	m_nSeenFlagsCount++;
}

void CPerception::AddSeenLine(ELineType lineID, double dist, double dir, double distChng, double dirChng, int setValues)
{
	CSeenLine line(lineID);
	line.SetDistance(dist);
	line.SetDirection(dir);
	line.SetDistanceChng(distChng);
	line.SetDirectionChng(dirChng);
	line.SetValuesVar(setValues);
	m_cSeenLines.push_back(line);
	m_nSeenLinesCount++;
}

void CPerception::AddSeenGoal(EGoalType goalID, double dist, double dir, double distChng, double dirChng, int setValues)
{
	CSeenGoal goal(goalID);
	goal.SetDistance(dist);
	goal.SetDirection(dir);
	goal.SetDistanceChng(distChng);
	goal.SetDirectionChng(dirChng);
	goal.SetValuesVar(setValues);
	m_cSeenGoals.push_back(goal);
	if(goalID == GT_L) {
		m_bSeeLeftGoal = true;
	}
	else if(goalID == GT_R) {
		m_bSeeRightGoal = true;
	}
}

void CPerception::AddSeenBall(double dist, double dir, double distChng, double dirChng, int setValues)
{
	m_cBall.SetDistance(dist);
	m_cBall.SetDirection(dir);
	m_cBall.SetDistanceChng(distChng);
	m_cBall.SetDirectionChng(dirChng);
	m_cBall.SetValuesVar(setValues);
	m_bSeeBall = true;
}

int CPerception::GetFirstPlayer(CSeenPlayer* player)
{
	int pos = 0;
	if(m_nSeenPlayersCount == 0)
		return -1;
	*player = m_cSeenPlayers[pos];
	return ++pos;
}

int CPerception::GetFirstFlag(CSeenFlag* flag)
{
	int pos = 0;
	if(m_nSeenFlagsCount == 0)
		return -1;
	*flag = m_cSeenFlags[pos];
	return ++pos;
}

int CPerception::GetFirstGoal(CSeenGoal* goal)
{
	int pos = 0;
	if(!m_bSeeLeftGoal && !m_bSeeRightGoal)
		return -1;
	*goal = m_cSeenGoals[pos];
	return ++pos;
}

int CPerception::GetFirstLine(CSeenLine* line)
{
	int pos = 0;
	if(m_nSeenLinesCount == 0)
		return -1;
	*line = m_cSeenLines[pos];
	return ++pos;
}

int CPerception::GetNextPlayer(CSeenPlayer* player, int currPos)
{
	if(currPos >= m_cSeenPlayers.size())
		return -1;
	*player = m_cSeenPlayers[currPos];
	return ++currPos;
}

int CPerception::GetNextFlag(CSeenFlag* flag, int currPos)
{
	if(currPos >= m_cSeenFlags.size())
		return -1;
	*flag = m_cSeenFlags[currPos];
	return ++currPos;
}

int CPerception::GetNextGoal(CSeenGoal* goal, int currPos)
{
	if(currPos >= m_cSeenGoals.size())
		return -1;
	*goal = m_cSeenGoals[currPos];
	return ++currPos;
}

int CPerception::GetNextLine(CSeenLine* line, int currPos)
{
	if(currPos >= m_cSeenLines.size())
		return -1;
	*line = m_cSeenLines[currPos];
	return ++currPos;
}

bool CPerception::GetBall(CSeenObject* ball)
{
	if(m_bSeeBall)
		*ball = m_cBall;
	return m_bSeeBall;
}

EPlayMode CPerception::GetPlayMode()
{ 
    if ((GetMsgType() == MT_Init) && (m_cInitMsg.IsValid())) 
    {
        return m_cInitMsg.GetPlayMode();
    } 
    else if ((GetMsgType() == MT_Hear) && (m_cHeardMsg.IsValid())) 
    {
        return m_cHeardMsg.GetPlayMode();
    }
    else return PM_NONE;
}

void CPerception::operator=(CPerception perception)
{
	int pos;
	CSeenPlayer player;
	CSeenFlag flag;
	CSeenGoal goal;
	CSeenLine line;

	ClearAll();
	m_tType = perception.GetMsgType();
	m_nPlayTime = perception.GetPlayTime();
	m_tGameTime = perception.GetGameTime();
	m_nReceiveSystemTime = perception.GetReceiveSystemTime();
	m_nSeenPlayersCount = perception.GetPlayersCount();
	m_nSeenPlaymatesCount = perception.GetPlaymatesCount();
	m_nSeenFlagsCount = perception.GetSeenFlagsCount();
	m_nSeenLinesCount = perception.GetSeenLinesCount();
	m_bSeeLeftGoal = perception.IsLeftGoalSeen();
	m_bSeeRightGoal = perception.IsRightGoalSeen();
	m_bSeeBall = perception.IsBallSeen();
	pos = 0;
	while((pos = perception.GetNextPlayer(&player, pos)) != -1)
		m_cSeenPlayers.push_back(player);	
	pos = 0;
	while((pos = perception.GetNextFlag(&flag, pos)) != -1)
		m_cSeenFlags.push_back(flag);
	pos = 0;
	while((pos = perception.GetNextGoal(&goal, pos)) != -1)
		m_cSeenGoals.push_back(goal);
	pos = 0;
	while((pos = perception.GetNextLine(&line, pos)) != -1)
		m_cSeenLines.push_back(line);
	perception.GetBall(&m_cBall);
	perception.GetHeardMgs(&m_cHeardMsg);
	perception.GetSenseBody(&m_cSenseBody);
	perception.GetInitMsg(&m_cInitMsg);
}

/* implementation of the CPerceptionSeq class. */
/**
* Adds new percption in perception FIFO queue
* @param pPerception is pointer to perception object, that is stored
* @return poiter on actual perception queue object
*/
CPerceptionSeq* CPerceptionSeq::AddPerception(CPerception *pPerception) 
{
	m_cPerceptions.push(pPerception);
	return this;
}

/**
* Returns and removes the fist perception pointer from perception queue
* @param pPerception is varialble in whitch is stored pointer on first perception object in perception queue. (free memory after use!) 
* @return true if perception queue is empty 
*/  
bool CPerceptionSeq::GetPerception(CPerception **pPerception)
{
	if(m_cPerceptions.size() > 0)
	{
		*pPerception = m_cPerceptions.front();
		m_cPerceptions.pop();
		return true;
	}
	else return false;
}

int CPerceptionSeq::GetPerceptionsCount() {
	return m_cPerceptions.size();
}
