// Parser.h: interface for the CParser class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_PARSER_H__AF94B835_C7BF_11D4_B629_5254AB1FA814__INCLUDED_)
#define AFX_PARSER_H__AF94B835_C7BF_11D4_B629_5254AB1FA814__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Perception.h"
#include <string>

using namespace std;

#define MAX_MSG_LEN 512

/*
Name: CCharString
Purpose: Wraper class for "string"
Notes: 
Created: 5.12.2000, frz
Last Modified: 6.12.2000, frz
*/
class CCharString
{
protected:
	string m_sString;
public:
	CCharString();
	CCharString(char* str);
	~CCharString();
	int GetStrLength(){return m_sString.size();}
	string GetString(){return m_sString;}
};

/*
Name: CParseString
Purpose: Class for with methods for parsing stored string
Notes: 
Created: 5.12.2000, frz 
Last Modified: 7.12.2000, frz
*/
class CParseString : public CCharString
{
private:

public:
	CParseString();
	CParseString(char* str);
	~CParseString();
	int GetInteger(){return atoi(m_sString.data());}
	double GetDouble(){return atof(m_sString.data());}
	int GetFirstWord(CParseString* subString);
	int GetFirstBar(CParseString* subString);
	int GetNextWord(int pos, CParseString* subString);
	int GetNextBar(int pos, CParseString* subString);
	int GetWordCount();
	int GetBarCount();
	bool operator==(CParseString str);
	bool operator==(CCharString str);
	bool operator==(string sString);
	bool operator==(char* szString);
	void operator=(CParseString str);
	void operator=(CCharString str);
	void operator=(string sString);
	void operator=(char* szString);
};

/*
Name: CParser
Purpose: Class for parsing information from soccer server
Notes: 
Created: 5.12.2000, frz 
Last Modified: 7.12.2000, frz
*/
class CParser  
{
public:
	CParser();
	virtual ~CParser();
	void Parse(char* msg, CPerception* newPerception);
	void ParseObj(CPerception* newPerception, CParseString* str);
	EFlagType DecodeFlag(CParseString f1, CParseString f2, CParseString f3);
    EPlayMode DecodePlayMode(CParseString pm);
};

#endif // !defined(AFX_PARSER_H__AF94B835_C7BF_11D4_B629_5254AB1FA814__INCLUDED_)
