// ObjectInfo.h: interface for the CObjectInfo class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_OBJECTINFO_H__0F229C7A_535C_4A5B_9DA9_BEEC8CA3B582__INCLUDED_)
#define AFX_OBJECTINFO_H__0F229C7A_535C_4A5B_9DA9_BEEC8CA3B582__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "WorldGeometry.h"

#define TYPE_UNKNOWN 0
#define TYPE_PLAYER 1
#define TYPE_GOAL 2
#define TYPE_BALL 3
#define TYPE_FLAG 4
#define TYPE_LINE 5

class CObjectInfo  
{
public:
    CObjectInfo(void);
	CObjectInfo(int type);
	virtual ~CObjectInfo();

protected:
    int m_iType;
    double m_dDistance;
    double m_dDirection;
    double m_dDistChange;
    double m_dDirChange;
    C2DVector m_vPosition;
};


/*
Player class
*/
class CPlayerInfo : public CObjectInfo
{
public:
    CPlayerInfo();
    virtual ~CPlayerInfo() {};

private:
    char m_sTeamName[25];
    int m_iUniformNumber;

};

/*
Goal class
*/
class CGoalInfo : public CObjectInfo
{
public:
    CGoalInfo();
    virtual ~CGoalInfo() {};

private:
    

};

/*
Ball class
*/
class CBallInfo : public CObjectInfo
{
public:
    CBallInfo();
    virtual ~CBallInfo() {};

private:
    

};

/*
Flag class
*/
class CFlagInfo : public CObjectInfo
{
public:
    CFlagInfo();
    virtual ~CFlagInfo() {};

private:
    int flagPos;    //tu sa bude drzat id vlajky, treba zadefinovat
};

/*
Line class
*/
class CLineInfo : public CObjectInfo
{
public:
    CLineInfo();
    virtual ~CLineInfo() {};

private:
    int linePos;    //tu sa bude drzat id ciary, treba zadefinovat
};







#endif // !defined(AFX_OBJECTINFO_H__0F229C7A_535C_4A5B_9DA9_BEEC8CA3B582__INCLUDED_)
