// Coordinator.cpp : implementation file
//

#include "stdafx.h"
#include "Player.h"
#include "Coordinator.h"

#include "ChildView.h"  // FIXME
#include "WorldObjects.h"
#include "ToDoEvent.h"
#include "TextMessageBuffer.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

FILE *m_ff;

/////////////////////////////////////////////////////////////////////////////
// CCoordinator

IMPLEMENT_DYNCREATE(CCoordinator, CWinThread)

CEventDispatcher EventDispatcher;

CCoordinator::CCoordinator() : m_pServerConnection(NULL)
{
}

CCoordinator::~CCoordinator()
{
}

void Deliberate(CPerceptionSeq *pPerceptionSeq)
{
    static int todo = 0;
	static int todo2 = 0;
    static CGameCommandSeq cSendCommands;
    static CPerception rPerception;
    static CPerception rPerception0;
    static CLocalAgent aLocalAgent;
    CGameCommand cGameCommand;
    CPerception *pPerception;

	if (todo2 != 0) {
		todo2 = 0;
	}

	cGameCommand.m_tCmdType = CT__NONE;

	todo2 = 0;
    rPerception.ClearAll();
    while (pPerceptionSeq->GetPerception(&pPerception)) {
		rPerception = *pPerception;
		delete pPerception;
        if (rPerception.GetMsgType() == MT_See) {
//			fprintf(m_ff, "<see>\n");
//				nLastPlayTime = rPerception.GetPlayTime();
			if (rPerception.IsBallSeen()) {
				CSeenObject ball;
				rPerception.GetBall(&ball);
				if (ball.GetDistance() > 1.2) {
					if ((ball.GetDirection() < 5) && (ball.GetDirection() > -5)) {
						cGameCommand.m_tCmdType = CT__DASH;
						cGameCommand.m_val_A = 10.00;
					} else {
						cGameCommand.m_tCmdType = CT__TURN;
						cGameCommand.m_val_A = ball.GetDirection();
						todo2 = 11;
					}
				} else {
					cGameCommand.m_tCmdType = CT__KICK;
					cGameCommand.m_val_A = 50.00;
					cGameCommand.m_val_B =  0.00;
					log_msg("kick %lf %lf", cGameCommand.m_val_A, cGameCommand.m_val_B);
				}

				//todo = -1;
				//if (todo != -1) 
			} else {  // "(turn 15.00)";
        		cGameCommand.m_tCmdType = CT__TURN;
        		cGameCommand.m_val_A = 15.00;
            } //else todo = 0;
			todo = 0;

            cSendCommands.Add(&cGameCommand);

            static CSendDataEvent event;
            event.m_eType = ET__SEND_COMMANDS;
            event.m_pGameCommandSeq = &cSendCommands;
			fprintf(m_ff, "<send>\n");
            EventDispatcher.SendEvent(&event);

			if (m_pReadyView) {
				rPerception0 = rPerception;
				m_pReadyView->SetNewPerception(&rPerception0);

                // skusime bobrikov algoritmus lokalizacie 
                //   zatial len kvoli vizualizacii
				CChildView *vv = m_pReadyView;
                // nasledujucu sekciu zaremovat, aby sa nerobila LOKALIZACIA
                {
                  aLocalAgent.UpdatePlayerPosition(rPerception.GetSeenFlags(), rPerception.GetSeenGoals(),rPerception.GetSeenLines());
                  vv->m_pAgent->SetPosition(aLocalAgent.GetPosition());
                  vv->m_pAgent->SetDirection(aLocalAgent.GetDirection());
				  vv->m_pAgent->SetNeckDirection(aLocalAgent.GetNeckDirection());
                }
				m_pReadyView = NULL;  // FIXMEEEE
				vv->Invalidate();
			}
        }//else
//		if (rPerception.GetMsgType() == MT_Hear)
//			fprintf(m_ff, "<hear>\n");
		else
		if (rPerception.GetMsgType() == MT_SenseBody)
		{
			fprintf(m_ff, "<sensebody>\n");
			if (m_pReadyView)
			{
				rPerception0 = rPerception;
				m_pReadyView->SetNewPerception(&rPerception0);

                // skusime bobrikov algoritmus lokalizacie 
                //   zatial len kvoli vizualizacii
				CChildView *vv = m_pReadyView;
                // nasledujucu sekciu zaremovat, aby sa nerobila LOKALIZACIA
                {
				  CSenseBody my_body;
				  rPerception.GetSenseBody(&my_body);
				  aLocalAgent.UpdatePlayerProperties(&my_body);
				  vv->m_pAgent->SetDirection(aLocalAgent.GetDirection());
                }
			}
			
		}
    }

//    if (todo == 0) {  // "(dash 10.00)"
//        cGameCommand.m_tCmdType = CT__DASH;
//        cGameCommand.m_val = 10.00;
//		todo = 1;
//    } 
//	else 

    pPerceptionSeq->Clear();
}

void CCoordinator::Handle()
{
    EEventType eType;

    do {
        eType = EventDispatcher.m_pEvent->m_eType;
        if (eType == ET__NONE) break;
        EventDispatcher.m_pEvent->m_eType = ET__NONE;  // FIXME - nepekne

        switch (eType) {
        case ET__RECEIVED_MSG:
            m_pServerCommunicator->OnReceiveServerMsg();
            break;
        case ET__START_DELIBERATION:
            {
                CStartDeliberationEvent *pDeliberationEvent = (CStartDeliberationEvent *)EventDispatcher.m_pEvent;
                Deliberate(pDeliberationEvent->m_pPerceptionSeq); // FIXME + dalsie parametre
                break;
            };
        case ET__SEND_COMMANDS:
            {
                CSendDataEvent *pSendEvent = (CSendDataEvent *)EventDispatcher.m_pEvent;
                m_pServerCommunicator->SendCommands(pSendEvent->m_pGameCommandSeq);
                break;
            };
        }
    } while (1);
}

BOOL CCoordinator::InitInstance()
{
    m_ff = fopen("log.log", "wt");

    EventDispatcher.m_pCoordinator = this;

	/* CServerConnection sa vytvori az tu, aby sa zarucilo ze jeho message sink
	   bude v novom threade.
	*/
	AfxSocketInit();

    m_pSystemClock = new CSystemClock();
    m_pSystemClock->Initialize();   // FIXME: alebo Initialise()??

    m_pServerMsgTranslator = new CServerMsgTranslator();

    m_pPerceptionSeq = new CPerceptionSeq();

//    CGameCommandSeq *m_pSendCommandSeq; 
//    CGameCommandSeq *m_pSentCommandSeq; 
//    m_pSendCommandSeq = new CGameCommandSeq();
//    m_pSentCommandSeq = new CGameCommandSeq();

/*
CPerception rPrc;
CServerMsg mMsg;
mMsg.m_sMessage = "(init l 1 before_kick_off)";
m_pServerMsgTranslator->ParseServerMsg(&mMsg, &rPrc);

mMsg.m_sMessage = "(see 0 ((goal r) 66.7027 33) ((flag r t) 55.581 3) ((flag p r t) 42.4804 23) ((flag p r c) 53.7587 43))";
m_pServerMsgTranslator->ParseServerMsg(&mMsg, &rPrc);

mMsg.m_sMessage = "(hear 1134 referee play_on)";
m_pServerMsgTranslator->ParseServerMsg(&mMsg, &rPrc); */

    m_pGameState = new CGameState();

    // FIXME nesmu zavisiet priamo navzajom
	m_pServerConnection = new CServerConnection();
    m_pServerCommunicator = new CServerCommunicator();

    m_pServerConnection->Initialize(m_pSystemClock);
    m_pServerCommunicator->Initialize(m_pGameState, m_pPerceptionSeq, m_pSystemClock, m_pServerConnection, m_pServerMsgTranslator);

	/* len taky test */    
	m_pServerConnection->Connect("localhost", 6000);
	m_pServerConnection->SendMsg(CServerMsg("(init tim4 (version 5.00))"));
	Sleep( 2000 );
	m_pServerConnection->SendMsg(CServerMsg("(move 0 0)"));

/*	// odkomentuj pre rychly timer - treba este odkomentovat aj dva riadky v ExitInstance()
	TIMECAPS tc;
	timeGetDevCaps(&tc, sizeof (tc));
	TRACE("MaxPeriod: %d, MinPeriod %d\n", tc.wPeriodMax, tc.wPeriodMin);

	// !!!!! ta 50 dole znamena ze chces 50 milisekundovu presnost -
	// cim mensiu chces tym vacsia zataz systemu, hod tam nejvacsi cas aky potrebujes
	m_uTimerRes = min(max(tc.wPeriodMin, 50), tc.wPeriodMax);
	timeBeginPeriod(m_uTimerRes);

	// prvy paramter, je interval v ms - nemoze byt mensi, nez zvolena presnost timer,
	// takze presnost musi myt GCD vsetkych timerov ktore pustat
	// druhy parameter je resolution - presnost - 0 nejlepsia - tusim je to kolko ms plus minus
	// ti este nevadi
	m_wTimerID = timeSetEvent(10, 0, TimeProc, (unsigned long) this, TIME_PERIODIC); */

	TRACE("Coordinator thread running.\n");

	return TRUE;
}

int CCoordinator::ExitInstance()
{
    if (m_pServerConnection)
        m_pServerConnection->SendMsg(CServerMsg("(bye)"));

	TRACE("Coordinator thread exiting.\n");

/*	// odkomentuj pre rychly timer
	timeKillEvent(m_wTimerID);
	timeEndPeriod(m_uTimerRes); */

    if (m_pServerCommunicator)
        delete m_pServerCommunicator;
	if (m_pServerConnection)
		delete m_pServerConnection;
    if (m_pServerMsgTranslator)
        delete m_pServerMsgTranslator;
    if (m_pSystemClock)
        delete m_pSystemClock;

    fclose(m_ff);

	return CWinThread::ExitInstance();
}

BEGIN_MESSAGE_MAP(CCoordinator, CWinThread)
	//{{AFX_MSG_MAP(CCoordinator)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCoordinator message handlers


/////////////////////////////////////////////////////////////////////////////
// Globalna funkcia pre rychly timer

void CALLBACK TimeProc(UINT uID, UINT uMsg, DWORD dwUser, DWORD dw1, DWORD dw2)
{
	((CCoordinator*) dwUser)->OnMMTimer();
}

// !!!!!!!!!! Pozor! bezi v inom threade ako zvysok objektu CCoordinator!
void CCoordinator::OnMMTimer()
{
//    fprintf(m_ff, "MMTimer[ %d].\n", m_pSystemClock->GetTime());
//    m_pServerConnection->OnReceive2(0);
//    //TRACE("MMTimer[%d].\n", m_pSystemClock->GetTime());
}
