// Config.cpp: implementation of the CConfig class.
//
//////////////////////////////////////////////////////////////////////

#include "stdAfx.h"

#include "param.h"
#include "types.h"
#include "Config.h"

/*
Ak potrebujete pridat parameter,
treba ho pridat sem:
- subor .conf, 
- zoznam option_t opt[],
- definicia v Config.h
- default hodnoty v Config.cpp a param.h
(funkcia Getoption je skopirovana priamo
zo SoccerServera, takze ak treba pridat
nacitanie dalsich parametrov servera,
staci to skopirovat zo zdrojakov k serveru)
*/


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CConfig::CConfig()
{
	/* set default parameter */
	// server.conf
	gwidth = GOAL_WIDTH ;

	// agent.conf
	flength = FIELD_LENGTH ;
	fwidth = FIELD_WIDTH ;
	palength = PENALTY_AREA_LENGTH ;
	pawidth = PENALTY_AREA_WIDTH ;
}

CConfig::~CConfig()
{

}


void CConfig::GetOption(char *szFilename)
{
	option_t opt[] = 
	{
		// server.conf
		{"goal_width",			(void *)&gwidth,		VV_DOUBLE},

		// agent.conf
		{"field_length",		(void *)&flength,		VV_DOUBLE},
		{"field_width",			(void *)&fwidth,		VV_DOUBLE},
		{"penalty_area_length",	(void *)&palength,		VV_DOUBLE},
		{"penalty_area_width",	(void *)&pawidth,		VV_DOUBLE},
		{"\0",					NULL, 					0}
	} ;

	FILE *fp ;
	if ((fp = fopen(szFilename,"r")) == NULL) 
	{
		cerr << "cat't open config file " << szFilename << endl ;
		return ;
	}

	char buf[MaxMesg] ;
	while(fgets(buf,MaxMesg,fp) != NULL) 
	{
		/* ignore remark line */
		if (buf[0] == '#' || buf[0] == '\n')
			continue ;

		/* replace from ':' to ' ' */
		char *t = buf ;
		while(*t != NULLCHAR) 
		{
			if (*t == ':') *t = ' ' ;
			t++ ;
		}

		int n, p ;
		char com[256] ;
		char onoff[16] ;
		n = sscanf(buf,"%s", com) ;
		if (n < 1) 
		{
			cerr << "Illegal line : " << buf ;
			continue ;
		}

		for (p = 0 ; opt[p].vptr != NULL ; p++) 
		{
			if (strcmp(com, opt[p].optname))
				continue ;

			/* match */
			switch(opt[p].vsize) 
			{
				case VV_INT:
					n = sscanf(buf, "%s %d", com, (int *)opt[p].vptr) ;
					break ;

				case VV_STRING:
					n = sscanf(buf, "%s %s", com, (char *)opt[p].vptr) ;
					break ;

				case VV_DOUBLE:
					n = sscanf(buf, "%s %lf", com, (double *)opt[p].vptr) ;
					break ;

				case VV_BOOL:
					n = 2 ;
					*((int *)opt[p].vptr) = TRUE ;
					break ;

				case VV_ONOFF:
					n = sscanf(buf, "%s %s", com, onoff) ;
					*((int *)opt[p].vptr) = (!strcmp(onoff, "on")) ? TRUE : FALSE ;
					break ;
				}
				if (n < 2)
					cerr << "Illegal line (" << com << ") " << endl ;

				break ;
			}
			
		if (opt[p].vptr == NULL)
			cerr << "Illegal line (" << com << ") " << endl ;
	}

	fclose(fp) ;
}