// ServerConnection.cpp : implementation file
//

#include "stdafx.h"
#include "ServerConnection.h"
#include "ServerMsg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CServerConnection

CServerConnection::CServerConnection(CWinThread* pDefThread, CCoordinator* pCoordinator, CSystemClock* pSystemClock) :
	CEventRecipient(pDefThread, pCoordinator), m_pSystemClock(pSystemClock)
{
	RegisterEvent(ET__SRVCONNECT);
	RegisterEvent(ET__SEND_SRVMSG);
	RegisterEvent(ET__SRVDISCONNECT);
}

CServerConnection::~CServerConnection()
{
	UnregisterEvent(ET__SRVCONNECT);
	UnregisterEvent(ET__SEND_SRVMSG);
	UnregisterEvent(ET__SRVDISCONNECT);
}


// Do not edit the following lines, which are needed by ClassWizard.
#if 0
BEGIN_MESSAGE_MAP(CServerConnection, CAsyncSocket)
	//{{AFX_MSG_MAP(CServerConnection)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()
#endif	// 0

/////////////////////////////////////////////////////////////////////////////
// CServerConnection member functions

BOOL CServerConnection::Connect(LPCTSTR lpszHostAddress, UINT nHostPort)
{
	if (m_hSocket != INVALID_SOCKET)
		return FALSE;

	if (!Create(0, SOCK_DGRAM, FD_READ))
		return FALSE;

	memset(&m_sSockAddr, 0, sizeof(m_sSockAddr));
	LPSTR lpszAscii = (LPTSTR) lpszHostAddress;
	m_sSockAddr.sin_family	= AF_INET ;
	m_sSockAddr.sin_addr.s_addr = inet_addr(lpszAscii) ;
	if (m_sSockAddr.sin_addr.s_addr == INADDR_NONE)
	{
		LPHOSTENT lphost;
		lphost = gethostbyname(lpszAscii);
		if (lphost != NULL)
			m_sSockAddr.sin_addr.s_addr = ((LPIN_ADDR) lphost->h_addr)->s_addr;
		else
		{
			WSASetLastError(WSAEINVAL);
			return FALSE;
		}
	}
	m_sSockAddr.sin_port = htons((u_short) nHostPort) ;

	return TRUE;
}

void CServerConnection::OnReceive(int nErrorCode) 
{
	char szBuff[65467];
	int nSockAddrLen = sizeof (m_sSockAddr);

	szBuff[ReceiveFrom(szBuff, sizeof (szBuff), (SOCKADDR*) &m_sSockAddr, &nSockAddrLen, 0)] = 0;

//	CServerMsg* pSrvMsg = new CServerMsg();
//	pSrvMsg->m_sMessage = szBuff;
//  delete pSrvMsg;

    PostEvent(new CReceiveEvent(szBuff, m_pSystemClock->GetTime()));

	szBuff[50] = 0;
	TRACE("Received: %s\n", szBuff);
}

int CServerConnection::Send(const CServerMsg& cMsg)
{
	if (m_hSocket == INVALID_SOCKET)
		return FALSE;

	TRACE("Sending: %s\n", cMsg.m_sMessage.c_str());

	return SendTo(cMsg.m_sMessage.c_str(), cMsg.m_sMessage.size(),
		(SOCKADDR*) &m_sSockAddr, sizeof (m_sSockAddr), 0);
}

void CServerConnection::OnEvent(CBasicEvent *pEvent)
{
	TRACE("OnEvent: %d\n", pEvent->m_eEventType);
	switch (pEvent->m_eEventType)
	{
	case ET__SRVCONNECT:
		Connect(((CConnectEvent*) pEvent)->m_sHost.c_str(), ((CConnectEvent*) pEvent)->m_nPort);
		break;
	case ET__SEND_SRVMSG:
		Send(CServerMsg(((CSendEvent*) pEvent)->m_pSrvMsg->m_sMessage));
		break;
	case ET__SRVDISCONNECT:
		Close();
		break;
	}

	pEvent->Release();
}
