#include "stdafx.h"
#include "ServerCommunicator.h"

CServerCommunicator::CServerCommunicator(CWinThread* pDefThread, CCoordinator* pCoordinator, CSystemClock *pSystemClock) : 
    CEventRecipient(pDefThread, pCoordinator), m_pSystemClock(pSystemClock)
{
    RegisterEvent(ET__PROCESS_PERCEPTION);
    RegisterEvent(ET__ACT);
}

CServerCommunicator::~CServerCommunicator()
{
    UnregisterEvent(ET__PROCESS_PERCEPTION);
    UnregisterEvent(ET__ACT);
}

void CServerCommunicator::OnEvent(CBasicEvent *pEvent)
{
	TRACE("OnEvent: %d\n", pEvent->m_eEventType);

	switch (pEvent->m_eEventType)
	{
	case ET__PROCESS_PERCEPTION:
		break;
	case ET__ACT:
		break;
	}

	pEvent->Release();
}
