// PlayerAgent.cpp: implementation of the CPlayerAgent class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "player.h"
#include "PlayerAgent.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CPlayerAgent::CPlayerAgent() : CCoordinator(2)
{
    m_pSystemClock = new CSystemClock;
    m_pSystemClock->Initialize();

	m_pServerConnection = new CServerConnection(m_cThreadVector[0], this, m_pSystemClock);
    m_pServerMsgTranslator = new CServerMsgTranslator(m_cThreadVector[0], this);
    m_pServerCommunicator = new CServerCommunicator(m_cThreadVector[0], this, m_pSystemClock);

	PostEvent(new CConnectEvent("localhost", 6000));
	PostEvent(new CSendEvent("(init motkovia)"));
}

CPlayerAgent::~CPlayerAgent()
{
	PostEvent(new CSendEvent("(bye)"));
	PostEvent(new CBasicEvent(ET__SRVDISCONNECT, true));

	Sleep(1000);

    delete m_pServerCommunicator;
    delete m_pServerMsgTranslator;
	delete m_pServerConnection;
    delete m_pSystemClock;
}
