#ifndef PERCEPTIONTYPES_H
#define PERCEPTIONTYPES_H

#define INTERRUPTS_PER_SIMSTEP     10
#define INTERRUPTS_TO_DELIBERATE    5
#define INTERRUPTS_TO_SEND          3

#define NOT_EXISTING -32000

#define OUR_GOAL        0
#define OPP_GOAL        1

enum EMsgType {
        MT_NoMsg,
        MT_See,
        MT_Hear,
        MT_SenseBody,
		MT_Init
};

enum EFlagType {
        FT_NoFlag,
        FT_C,
        FT_LT,
        FT_LB,
        FT_CT,
        FT_CB,
        FT_RT,
        FT_RB,
        FT_PLT,
        FT_PLC,
        FT_PLB,
        FT_PRT,
        FT_PRC,
        FT_PRB,
        FT_GLT,
        FT_GLB,
        FT_GRT,
        FT_GRB,
        FT_TL10,
        FT_TL20,
        FT_TL30,
        FT_TL40,
        FT_TL50,
        FT_TR10,
        FT_TR20,
        FT_TR30,
        FT_TR40,
        FT_TR50,
        FT_BL10,
        FT_BL20,
        FT_BL30,
        FT_BL40,
        FT_BL50,
        FT_BR10,
        FT_BR20,
        FT_BR30,
        FT_BR40,
        FT_BR50,
        FT_LT10,
        FT_LT20,
        FT_LT30,
        FT_LB10,
        FT_LB20,
        FT_LB30,
        FT_RT10,
        FT_RT20,
        FT_RT30,
        FT_RB10,
        FT_RB20,
        FT_RB30,
        FT_T0,
        FT_B0,
        FT_L0,
        FT_R0,

        FT_COUNT,
};

enum ELineType {
        LT_NoLine,
        LT_L,
        LT_R,
        LT_T,
        LT_B,
        LT_Y
};

enum EGoalType {
        GT_NoGoal,
        GT_L,
        GT_R
};

enum EHearMsgType {
		MT_Nobody,
		MT_Referee,
		MT_Self,
		MT_Other
};


// toto sa mi vidi logickejsie, ako v enume vymenovane vsetky moznosti....



typedef double Value ;
typedef int ID ;
typedef int TheNumber ;
typedef char* Name ;
typedef int Logical ;

#define NULLCHAR	'\000'

#define TRUE 1 
#define FALSE 0 
#define	True 1
#define False 0

typedef struct {
	char	optname[32] ;
	void	*vptr ;
	int		vsize ;
} option_t ;

#define	VV_INT		1
#define	VV_DOUBLE	2
#define	VV_BOOL		3
#define	VV_STRING	4
#define	VV_ONOFF	5
#define VV_NONE		6

#define SEE_NOTHING					0x00000000
#define SEE_SIDE					0x00000001
#define SEE_NUMBER					0x00000002
#define SEE_DISTANCE				0x00000004
#define SEE_ANGLE				    0x00000008
#define SEE_DISTANCE_CHANGE			0x00000010
#define SEE_ANGLE_CHANGE		    0x00000030
#define SEE_BODY_DIRECTION			0x00000040
#define SEE_NECK_DIRECTION			0x00000080
#define SEE_STAMINA     			0x00000100
#define SEE_EFFORT         			0x00000200
#define SEE_MASK					0x00003fff

#define EXPECTED_NOTHING            0x00000000
#define EXPECTED_SIDE				0x00000400
#define EXPECTED_NUMBER				0x00000800
#define EXPECTED_DISTANCE			0x00001000
#define EXPECTED_ANGLE				0x00002000
#define EXPECTED_DISTANCE_CHANGE	0x00004000
#define EXPECTED_ANGLE_CHANGE		0x00008000
#define EXPECTED_BODY_DIRECTION		0x00010000
#define EXPECTED_NECK_DIRECTION		0x00020000
#define EXPECTED_STAMINA 		    0x00040000
#define EXPECTED_EFFORT 		    0x00080000
#define EXPECTED_ACCELERATION       0x00100000
#define EXPECTED_MASK               0x001ffc00

#define PREV_NOTHING                0x00000000
#define PREV_POSITION               0x00200000
#define PREV_SPEED                  0x00400000
#define PREV_ACCELERATION           0x00800000
#define PREV_MASK                   0x00e00000

#define VISUAL_RANGE_NARROW			0x00000000
#define VISUAL_RANGE_NORMAL			0x00000001
#define VISUAL_RANGE_WIDE			0x00000002
#define VISUAL_RANGE_MASK   		0x00000003
#define VISUAL_QUALITY_LOW			0x00000000
#define VISUAL_QUALITY_HIGH			0x00000004
#define VISUAL_QUALITY_MASK 		0x00000004

#define PI  3.14159265359

#define UNKNOWN -1

/*
enum ESetValues {
		SV_None = 0,
		SV_DirChng,
		SV_DistChng,
		SV_DirChngDistChng,
		SV_Dir,
		SV_DirDirChng,
		SV_DirDistChng,
		SV_DirDistChngDirChng,
		SV_Dist,
		SV_DistDirChng,
		SV_DistDistChng,
		SV_DistDistChngDirChng,
		SV_DistDir,
		SV_DistDirDirChng,
		SV_DistDirDistChng,
		SV_DistDirDistChngDirChng
};
*/
enum EViewQuality {
		VQ_None,
		VQ_Low,
		VQ_High
};

enum EViewWidth {
		VW_None,
		VW_Narrow,
		VW_Normal,
		VW_Wide
};

enum ESide {
		S_None,
		S_Left,
		S_Right
};

#endif  // PERCEPTIONTYPES_H
