// EventRecipient.h: interface for the CEventRecipient class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_EVENTRECIPIENT_H__759E8307_CED7_11D4_BEC2_00C0CA122103__INCLUDED_)
#define AFX_EVENTRECIPIENT_H__759E8307_CED7_11D4_BEC2_00C0CA122103__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "EventThread.h"
#include "Coordinator.h"

#define DEFAULT_THREAD NULL

class CEventThread;
class CCoordinator;

class CEventRecipient  
{
public:
	CEventRecipient(CWinThread* pDefThread, CCoordinator* pCoordinator);
	virtual ~CEventRecipient();

	virtual void OnEvent(CBasicEvent* pEvent);

protected:
	void RegisterEvent(EEventType eType, CWinThread* pThread = DEFAULT_THREAD);
	void UnregisterEvent(EEventType eType, CWinThread* pThread = DEFAULT_THREAD);
	void PostEvent(CBasicEvent* pEvent);
	void SendEvent(CBasicEvent* pEvent);

	CCoordinator* m_pCoordinator;
	CWinThread* m_pDefThread;
};

#endif // !defined(AFX_EVENTRECIPIENT_H__759E8307_CED7_11D4_BEC2_00C0CA122103__INCLUDED_)
