// EventRecipient.cpp: implementation of the CEventRecipient class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Player.h"
#include "EventRecipient.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CEventRecipient::CEventRecipient(CWinThread* pDefThread, CCoordinator* pCoordinator) :
	m_pDefThread(pDefThread), m_pCoordinator(pCoordinator)
{
}

CEventRecipient::~CEventRecipient()
{
}

void CEventRecipient::PostEvent(CBasicEvent *pEvent)
{
	m_pCoordinator->PostEvent(pEvent);
}

void CEventRecipient::SendEvent(CBasicEvent *pEvent)
{
	m_pCoordinator->PostEvent(pEvent, true);
}

void CEventRecipient::RegisterEvent(EEventType eType, CWinThread *pThread)
{
	m_pCoordinator->RegisterEventRecipient(eType, pThread == DEFAULT_THREAD ? m_pDefThread : pThread, this);
}

void CEventRecipient::UnregisterEvent(EEventType eType, CWinThread *pThread)
{
	m_pCoordinator->UnregisterEventRecipient(eType, pThread == DEFAULT_THREAD ? m_pDefThread : pThread, this);
}

void CEventRecipient::OnEvent(CBasicEvent *pEvent)
{
	pEvent->Release();
}
