// BasicEvent.h: interface for the CBasicEvent class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_BASICEVENT_H__759E8308_CED7_11D4_BEC2_00C0CA122103__INCLUDED_)
#define AFX_BASICEVENT_H__759E8308_CED7_11D4_BEC2_00C0CA122103__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#pragma warning (disable : 4786)

#include "ServerMsg.h"
#include "Perception.h"
#include <string>
using namespace std;

enum EEventType { 
    ET__SRVCONNECT,
    ET__SRVDISCONNECT,
    ET__RECEIVE_SRVMSG,
    ET__SEND_SRVMSG,
    ET__PROCESS_PERCEPTION,
    ET__SEND_COMMAND,
    ET__DELIBERATE,
    ET__ACT
};

class CBasicEvent  
{
public:
	CBasicEvent(EEventType eType, bool bTemp = false);
	virtual ~CBasicEvent();
	
	long AddRef();
	long Release();

	EEventType m_eEventType;

protected:
	long m_nRefCount;
};


class CConnectEvent : public CBasicEvent  
{
public:
	string m_sHost;
	unsigned m_nPort;

public:
	CConnectEvent(string sHost, unsigned nPort);
	virtual ~CConnectEvent();
};

class CSendEvent : public CBasicEvent  
{
public:
    CServerMsg *m_pSrvMsg;

public:
	CSendEvent(CServerMsg *pSrvMsg);
    CSendEvent(string sMessage);
	virtual ~CSendEvent();
};

class CReceiveEvent : public CBasicEvent  
{
public:
    CServerMsg *m_pSrvMsg;

public:
	CReceiveEvent(CServerMsg *pSrvMsg);
    CReceiveEvent(string sMessage, TSystemTime tReceivedTime);
	virtual ~CReceiveEvent();
};

class CProcessPerceptionEvent : public CBasicEvent
{
public:
    CPerception *m_pPerception;

public:
	CProcessPerceptionEvent(CPerception *pPerception);
	virtual ~CProcessPerceptionEvent();
};

#endif // !defined(AFX_BASICEVENT_H__759E8308_CED7_11D4_BEC2_00C0CA122103__INCLUDED_)
