// BasicEvent.cpp: implementation of the CBasicEvent class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Player.h"
#include "Event.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CBasicEvent::CBasicEvent(EEventType eType, bool bTemp) : m_eEventType(eType)
{
	if (bTemp)
		m_nRefCount = 0;
	else
		m_nRefCount = 1;
}

CBasicEvent::~CBasicEvent()
{
	TRACE("~CBasicEvent: %d\n", m_eEventType);
}

long CBasicEvent::AddRef()
{
	return InterlockedIncrement(&m_nRefCount);
}

long CBasicEvent::Release()
{
	long nNewCount = InterlockedDecrement(&m_nRefCount);
	if (!nNewCount)
		delete this;
	return nNewCount;
}

//////////////////////////////////////////////////////////////////////
// CConnectEvent Class
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CConnectEvent::CConnectEvent(string sHost, unsigned nPort) :
	CBasicEvent(ET__SRVCONNECT, true), m_sHost(sHost), m_nPort(nPort)
{
}

CConnectEvent::~CConnectEvent()
{
}

//////////////////////////////////////////////////////////////////////
// CSendEvent Class
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CSendEvent::CSendEvent(CServerMsg *pSrvMsg) :
	CBasicEvent(ET__SEND_SRVMSG, true), m_pSrvMsg(pSrvMsg)
{
}

CSendEvent::CSendEvent(string sMessage) :
    CBasicEvent(ET__SEND_SRVMSG, true), m_pSrvMsg(new CServerMsg(sMessage))
{
}

CSendEvent::~CSendEvent()
{
    if (m_pSrvMsg)
        delete m_pSrvMsg;
}

//////////////////////////////////////////////////////////////////////
// CReceiveEvent Class
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CReceiveEvent::CReceiveEvent(CServerMsg *pSrvMsg) :
	CBasicEvent(ET__RECEIVE_SRVMSG, true), m_pSrvMsg(pSrvMsg)
{
}

CReceiveEvent::CReceiveEvent(string sMessage, TSystemTime tReceivedTime) :
    CBasicEvent(ET__RECEIVE_SRVMSG, true), m_pSrvMsg(new CServerMsg(sMessage, tReceivedTime))
{
}

CReceiveEvent::~CReceiveEvent()
{
    if (m_pSrvMsg) {
        delete m_pSrvMsg;
        m_pSrvMsg = NULL;
    }
}

//////////////////////////////////////////////////////////////////////
// CReceiveEvent Class
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CProcessPerceptionEvent::CProcessPerceptionEvent(CPerception *pPerception) :
    CBasicEvent(ET__PROCESS_PERCEPTION, true), m_pPerception(pPerception)
{
}

CProcessPerceptionEvent::~CProcessPerceptionEvent()
{
    if (m_pPerception) {
        delete m_pPerception;
        m_pPerception = NULL;
    }
}
