// Coordinator.h: interface for the CCoordinator class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_COORDINATOR_H__759E8306_CED7_11D4_BEC2_00C0CA122103__INCLUDED_)
#define AFX_COORDINATOR_H__759E8306_CED7_11D4_BEC2_00C0CA122103__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Event.h"

#pragma warning (disable : 4786 4503)

#include <vector>
#include <map>
#include <set>

using namespace std;

class CEventRecipient;
class CEventThread;

typedef vector<CWinThread*> CThreadVector;

typedef set<CEventRecipient*> CRecipientSet;
typedef map<CWinThread*, CRecipientSet> CThreadRecMap;
typedef map<EEventType, CThreadRecMap> CEventMap;

#include "EventRecipient.h"
#include "EventThread.h"

class CCoordinator  
{
public:
	CCoordinator(int nNumEventThreads);
	virtual ~CCoordinator();

	void RegisterEventRecipient(EEventType eType, CWinThread* pThread, CEventRecipient* pRecipient);
	void UnregisterEventRecipient(EEventType eType, CWinThread* pThread, CEventRecipient* pRecipient);
	void RegisterEventThread(EEventType eType, CWinThread* pThread);
	void UnregisterEventThread(EEventType eType, CWinThread* pThread);
	void PostEvent(CBasicEvent* pEvent, bool bSync = false);

	CThreadVector m_cThreadVector;

protected:
	CEventMap m_cEventMap;
};

#endif // !defined(AFX_COORDINATOR_H__759E8306_CED7_11D4_BEC2_00C0CA122103__INCLUDED_)
