// Coordinator.cpp: implementation of the CCoordinator class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Player.h"
#include "Coordinator.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CCoordinator::CCoordinator(int nNumEventThreads)
{
	for (int i = 0; i < nNumEventThreads; i++)
		m_cThreadVector.push_back(AfxBeginThread(RUNTIME_CLASS(CEventThread), THREAD_PRIORITY_HIGHEST, 0, 0, NULL));
}

CCoordinator::~CCoordinator()
{
	while (!m_cThreadVector.empty())
	{
		m_cThreadVector.back()->PostThreadMessage(WM_QUIT, 0, 0);
		m_cThreadVector.pop_back();
	}
}

void CCoordinator::PostEvent(CBasicEvent* pEvent, bool bSync)
{
	TRACE("PostEvent: %d\n", pEvent->m_eEventType);

	CWinThread* cCurrentThread = bSync ? AfxGetThread() : NULL;

	pEvent->AddRef();
	CThreadRecMap* pThreadRecMap = &m_cEventMap[pEvent->m_eEventType];
	CThreadRecMap::iterator iThread = pThreadRecMap->begin();
	do
	{
		pEvent->AddRef();

		if (iThread->first == cCurrentThread && iThread->first->IsKindOf(RUNTIME_CLASS(CEventThread)))
			((CEventThread*) iThread->first)->OnEvent(pEvent, &iThread->second);
		else
			iThread->first->PostThreadMessage(WM_EVENT, (unsigned int) pEvent, (long) &iThread->second);
	} while (++iThread != pThreadRecMap->end());
	pEvent->Release();
}

void CCoordinator::RegisterEventRecipient(EEventType eType, CWinThread* pThread, CEventRecipient* pRecipient)
{
	m_cEventMap[eType][pThread].insert(pRecipient);
}

void CCoordinator::UnregisterEventRecipient(EEventType eType, CWinThread* pThread, CEventRecipient* pRecipient)
{
	m_cEventMap[eType][pThread].erase(pRecipient);
	if (m_cEventMap[eType][pThread].empty())
		m_cEventMap[eType].erase(pThread);
}

void CCoordinator::RegisterEventThread(EEventType eType, CWinThread *pThread)
{
	m_cEventMap[eType].insert(CThreadRecMap::value_type(pThread, CRecipientSet()));
}

void CCoordinator::UnregisterEventThread(EEventType eType, CWinThread *pThread)
{
	m_cEventMap[eType].erase(pThread);
}
